/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.RecordParser;
import com.aerospike.client.command.SyncCommand;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.policy.WritePolicy;
import java.io.IOException;

public abstract class SyncWriteCommand
extends SyncCommand {
    final WritePolicy writePolicy;
    final Key key;
    final Partition partition;

    public SyncWriteCommand(Cluster cluster, WritePolicy writePolicy, Key key) {
        super(cluster, writePolicy);
        this.writePolicy = writePolicy;
        this.key = key;
        this.partition = Partition.write(cluster, writePolicy, key);
        cluster.addCommandCount();
    }

    @Override
    protected boolean isWrite() {
        return true;
    }

    @Override
    protected Node getNode() {
        return this.partition.getNodeWrite(this.cluster);
    }

    @Override
    protected LatencyType getLatencyType() {
        return LatencyType.WRITE;
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        this.partition.prepareRetryWrite(timeout);
        return true;
    }

    @Override
    protected void onInDoubt() {
        if (this.writePolicy.txn != null) {
            this.writePolicy.txn.onWriteInDoubt(this.key);
        }
    }

    protected int parseHeader(Connection conn) throws IOException {
        RecordParser rp = new RecordParser(conn, this.dataBuffer);
        rp.parseFields(this.policy.txn, this.key, true);
        return rp.resultCode;
    }
}

