/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.exp;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.MapPolicy;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.exp.ListExp;
import com.aerospike.client.util.Pack;

public final class MapExp {
    private static final int MODULE = 0;
    private static final int PUT = 67;
    private static final int PUT_ITEMS = 68;
    private static final int REPLACE = 69;
    private static final int REPLACE_ITEMS = 70;
    private static final int INCREMENT = 73;
    private static final int CLEAR = 75;
    private static final int REMOVE_BY_KEY = 76;
    private static final int REMOVE_BY_INDEX = 77;
    private static final int REMOVE_BY_RANK = 79;
    private static final int REMOVE_BY_KEY_LIST = 81;
    private static final int REMOVE_BY_VALUE = 82;
    private static final int REMOVE_BY_VALUE_LIST = 83;
    private static final int REMOVE_BY_KEY_INTERVAL = 84;
    private static final int REMOVE_BY_INDEX_RANGE = 85;
    private static final int REMOVE_BY_VALUE_INTERVAL = 86;
    private static final int REMOVE_BY_RANK_RANGE = 87;
    private static final int REMOVE_BY_KEY_REL_INDEX_RANGE = 88;
    private static final int REMOVE_BY_VALUE_REL_RANK_RANGE = 89;
    private static final int SIZE = 96;
    private static final int GET_BY_KEY = 97;
    private static final int GET_BY_INDEX = 98;
    private static final int GET_BY_RANK = 100;
    private static final int GET_BY_VALUE = 102;
    private static final int GET_BY_KEY_INTERVAL = 103;
    private static final int GET_BY_INDEX_RANGE = 104;
    private static final int GET_BY_VALUE_INTERVAL = 105;
    private static final int GET_BY_RANK_RANGE = 106;
    private static final int GET_BY_KEY_LIST = 107;
    private static final int GET_BY_VALUE_LIST = 108;
    private static final int GET_BY_KEY_REL_INDEX_RANGE = 109;
    private static final int GET_BY_VALUE_REL_RANK_RANGE = 110;

    public static Exp put(MapPolicy policy, Exp key, Exp value, Exp bin, CTX ... ctx) {
        byte[] bytes = policy.flags != 0 ? Pack.pack(67, key, value, policy.attributes, policy.flags, ctx) : (policy.itemCommand == 69 ? Pack.pack(policy.itemCommand, key, value, ctx) : Pack.pack(policy.itemCommand, key, value, policy.attributes, ctx));
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp putItems(MapPolicy policy, Exp map, Exp bin, CTX ... ctx) {
        byte[] bytes = policy.flags != 0 ? Pack.pack(68, map, policy.attributes, policy.flags, ctx) : (policy.itemsCommand == 70 ? Pack.pack(policy.itemsCommand, map, ctx) : Pack.pack(policy.itemsCommand, map, policy.attributes, ctx));
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp increment(MapPolicy policy, Exp key, Exp incr, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(73, key, incr, policy.attributes, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp clear(Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(75, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByKey(Exp key, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(76, 0, key, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByKeyList(int returnType, Exp keys, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(81, returnType, keys, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByKeyRange(int returnType, Exp keyBegin, Exp keyEnd, Exp bin, CTX ... ctx) {
        byte[] bytes = ListExp.packRangeOperation(84, returnType, keyBegin, keyEnd, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByKeyRelativeIndexRange(int returnType, Exp key, Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(88, returnType, key, index2, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByKeyRelativeIndexRange(int returnType, Exp key, Exp index2, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(88, returnType, key, index2, count, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValue(int returnType, Exp value, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(82, returnType, value, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValueList(int returnType, Exp values, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(83, returnType, values, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValueRange(int returnType, Exp valueBegin, Exp valueEnd, Exp bin, CTX ... ctx) {
        byte[] bytes = ListExp.packRangeOperation(86, returnType, valueBegin, valueEnd, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValueRelativeRankRange(int returnType, Exp value, Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(89, returnType, value, rank, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByValueRelativeRankRange(int returnType, Exp value, Exp rank, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(89, returnType, value, rank, count, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByIndex(Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(77, 0, index2, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByIndexRange(int returnType, Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(85, returnType, index2, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByIndexRange(int returnType, Exp index2, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(85, returnType, index2, count, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByRank(Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(79, 0, rank, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByRankRange(int returnType, Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(87, returnType, rank, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp removeByRankRange(int returnType, Exp rank, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(87, returnType, rank, count, ctx);
        return MapExp.addWrite(bin, bytes, ctx);
    }

    public static Exp size(Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(96, ctx);
        return MapExp.addRead(bin, bytes, Exp.Type.INT);
    }

    public static Exp getByKey(int returnType, Exp.Type valueType, Exp key, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(97, returnType, key, ctx);
        return MapExp.addRead(bin, bytes, valueType);
    }

    public static Exp getByKeyRange(int returnType, Exp keyBegin, Exp keyEnd, Exp bin, CTX ... ctx) {
        byte[] bytes = ListExp.packRangeOperation(103, returnType, keyBegin, keyEnd, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByKeyList(int returnType, Exp keys, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(107, returnType, keys, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByKeyRelativeIndexRange(int returnType, Exp key, Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(109, returnType, key, index2, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByKeyRelativeIndexRange(int returnType, Exp key, Exp index2, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(109, returnType, key, index2, count, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByValue(int returnType, Exp value, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(102, returnType, value, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByValueRange(int returnType, Exp valueBegin, Exp valueEnd, Exp bin, CTX ... ctx) {
        byte[] bytes = ListExp.packRangeOperation(105, returnType, valueBegin, valueEnd, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByValueList(int returnType, Exp values, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(108, returnType, values, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByValueRelativeRankRange(int returnType, Exp value, Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(110, returnType, value, rank, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByValueRelativeRankRange(int returnType, Exp value, Exp rank, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(110, returnType, value, rank, count, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByIndex(int returnType, Exp.Type valueType, Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(98, returnType, index2, ctx);
        return MapExp.addRead(bin, bytes, valueType);
    }

    public static Exp getByIndexRange(int returnType, Exp index2, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(104, returnType, index2, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByIndexRange(int returnType, Exp index2, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(104, returnType, index2, count, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByRank(int returnType, Exp.Type valueType, Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(100, returnType, rank, ctx);
        return MapExp.addRead(bin, bytes, valueType);
    }

    public static Exp getByRankRange(int returnType, Exp rank, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(106, returnType, rank, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    public static Exp getByRankRange(int returnType, Exp rank, Exp count, Exp bin, CTX ... ctx) {
        byte[] bytes = Pack.pack(106, returnType, rank, count, ctx);
        return MapExp.addRead(bin, bytes, MapExp.getValueType(returnType));
    }

    private static Exp addWrite(Exp bin, byte[] bytes, CTX[] ctx) {
        int retType = ctx == null || ctx.length == 0 ? Exp.Type.MAP.code : ((ctx[0].id & 0x10) == 0 ? Exp.Type.MAP.code : Exp.Type.LIST.code);
        return new Exp.Module(bin, bytes, retType, 64);
    }

    private static Exp addRead(Exp bin, byte[] bytes, Exp.Type retType) {
        return new Exp.Module(bin, bytes, retType.code, 0);
    }

    private static Exp.Type getValueType(int returnType) {
        int t = returnType & 0xFFFEFFFF;
        switch (t) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return Exp.Type.LIST;
            }
            case 5: {
                return Exp.Type.INT;
            }
            case 6: 
            case 7: {
                return Exp.Type.LIST;
            }
            case 8: 
            case 16: 
            case 17: {
                return Exp.Type.MAP;
            }
            case 13: {
                return Exp.Type.BOOL;
            }
        }
        throw new AerospikeException("Invalid MapReturnType: " + returnType);
    }
}

