/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.Value;
import com.aerospike.client.cdt.MapOrder;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public final class Bin {
    public final String name;
    public final Value value;

    public Bin(String name, String value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, byte[] value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, byte[] value, int type2) {
        this.name = name;
        this.value = Value.get(value, type2);
    }

    public Bin(String name, byte[] value, int offset, int length) {
        this.name = name;
        this.value = Value.get(value, offset, length);
    }

    public Bin(String name, byte value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, short value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, int value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, long value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, double value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, float value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, boolean value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, List<?> value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, Map<?, ?> value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Bin(String name, SortedMap<?, ?> value) {
        this.name = name;
        this.value = Value.get(value);
    }

    @Deprecated
    public Bin(String name, Map<?, ?> value, MapOrder mapOrder) {
        this.name = name;
        this.value = Value.get(value, mapOrder);
    }

    public Bin(String name, List<? extends Map.Entry<?, ?>> value, MapOrder mapOrder) {
        this.name = name;
        this.value = Value.get(value, mapOrder);
    }

    public Bin(String name, Value value) {
        this.name = name;
        this.value = value;
    }

    public static Bin asNull(String name) {
        return new Bin(name, Value.getAsNull());
    }

    public static Bin asGeoJSON(String name, String value) {
        return new Bin(name, Value.getAsGeoJSON(value));
    }

    public String toString() {
        return this.name + ':' + this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bin other = (Bin)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }
}

