/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.util.Pack;
import java.util.Arrays;

public final class Filter {
    private final String name;
    private final IndexCollectionType colType;
    private final byte[] packedCtx;
    private final int valType;
    private final Value begin;
    private final Value end;

    public static Filter equal(String name, long value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val.getType(), val, val, ctx);
    }

    public static Filter equal(String name, String value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val.getType(), val, val, ctx);
    }

    public static Filter equal(String name, byte[] value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, IndexCollectionType.DEFAULT, val.getType(), val, val, ctx);
    }

    public static Filter contains(String name, IndexCollectionType type2, long value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, type2, val.getType(), val, val, ctx);
    }

    public static Filter contains(String name, IndexCollectionType type2, String value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, type2, val.getType(), val, val, ctx);
    }

    public static Filter contains(String name, IndexCollectionType type2, byte[] value, CTX ... ctx) {
        Value val = Value.get(value);
        return new Filter(name, type2, val.getType(), val, val, ctx);
    }

    public static Filter range(String name, long begin, long end, CTX ... ctx) {
        return new Filter(name, IndexCollectionType.DEFAULT, 1, Value.get(begin), Value.get(end), ctx);
    }

    public static Filter range(String name, IndexCollectionType type2, long begin, long end, CTX ... ctx) {
        return new Filter(name, type2, 1, Value.get(begin), Value.get(end), ctx);
    }

    public static Filter geoWithinRegion(String name, String region, CTX ... ctx) {
        return new Filter(name, IndexCollectionType.DEFAULT, 23, Value.get(region), Value.get(region), ctx);
    }

    public static Filter geoWithinRegion(String name, IndexCollectionType type2, String region, CTX ... ctx) {
        return new Filter(name, type2, 23, Value.get(region), Value.get(region), ctx);
    }

    public static Filter geoWithinRadius(String name, double lng, double lat, double radius, CTX ... ctx) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(name, IndexCollectionType.DEFAULT, 23, Value.get(rgnstr), Value.get(rgnstr), ctx);
    }

    public static Filter geoWithinRadius(String name, IndexCollectionType type2, double lng, double lat, double radius, CTX ... ctx) {
        String rgnstr = String.format("{ \"type\": \"AeroCircle\", \"coordinates\": [[%.8f, %.8f], %f] }", lng, lat, radius);
        return new Filter(name, type2, 23, Value.get(rgnstr), Value.get(rgnstr), ctx);
    }

    public static Filter geoContains(String name, String point, CTX ... ctx) {
        return new Filter(name, IndexCollectionType.DEFAULT, 23, Value.get(point), Value.get(point), ctx);
    }

    public static Filter geoContains(String name, IndexCollectionType type2, String point, CTX ... ctx) {
        return new Filter(name, type2, 23, Value.get(point), Value.get(point), ctx);
    }

    private Filter(String name, IndexCollectionType colType, int valType, Value begin, Value end, CTX[] ctx) {
        this(name, colType, valType, begin, end, ctx != null && ctx.length > 0 ? Pack.pack(ctx) : null);
    }

    Filter(String name, IndexCollectionType colType, int valType, Value begin, Value end, byte[] packedCtx) {
        this.name = name;
        this.colType = colType;
        this.valType = valType;
        this.begin = begin;
        this.end = end;
        this.packedCtx = packedCtx;
    }

    public int estimateSize() {
        return Buffer.estimateSizeUtf8(this.name) + this.begin.estimateSize() + this.end.estimateSize() + 10;
    }

    public int write(byte[] buf, int offset) {
        int len2 = Buffer.stringToUtf8(this.name, buf, offset + 1);
        buf[offset] = (byte)len2;
        offset += len2 + 1;
        buf[offset++] = (byte)this.valType;
        len2 = this.begin.write(buf, offset + 4);
        Buffer.intToBytes(len2, buf, offset);
        offset += len2 + 4;
        len2 = this.end.write(buf, offset + 4);
        Buffer.intToBytes(len2, buf, offset);
        return offset += len2 + 4;
    }

    public IndexCollectionType getCollectionType() {
        return this.colType;
    }

    public String getName() {
        return this.name;
    }

    public IndexCollectionType getColType() {
        return this.colType;
    }

    public Value getBegin() {
        return this.begin;
    }

    public Value getEnd() {
        return this.end;
    }

    public int getValType() {
        return this.valType;
    }

    public byte[] getPackedCtx() {
        return this.packedCtx;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        if (this.begin == null ? other.begin != null : !this.begin.equals(other.begin)) {
            return false;
        }
        if (this.colType != other.colType) {
            return false;
        }
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.equals(this.packedCtx, other.packedCtx)) {
            return false;
        }
        return this.valType == other.valType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.begin == null ? 0 : this.begin.hashCode());
        result = 31 * result + (this.colType == null ? 0 : this.colType.hashCode());
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.packedCtx);
        result = 31 * result + this.valType;
        return result;
    }
}

