/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncQueryValidate;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;

public abstract class AsyncMultiExecutor {
    final EventLoop eventLoop;
    final Cluster cluster;
    private AsyncMultiCommand[] commands;
    private String namespace;
    private AerospikeException exception;
    private long clusterKey;
    private final int infoTimeout;
    private int maxConcurrent;
    private int completedCount;
    boolean done;

    public AsyncMultiExecutor(EventLoop eventLoop, Cluster cluster, int infoTimeout) {
        this.eventLoop = eventLoop;
        this.cluster = cluster;
        this.infoTimeout = infoTimeout;
    }

    public void execute(AsyncMultiCommand[] commands, int maxConcurrent) {
        this.commands = commands;
        this.maxConcurrent = maxConcurrent == 0 || maxConcurrent >= commands.length ? commands.length : maxConcurrent;
        for (int i = 0; i < this.maxConcurrent; ++i) {
            this.eventLoop.execute(this.cluster, commands[i]);
        }
    }

    public void executeValidate(final AsyncMultiCommand[] commands, int maxConcurrent, String namespace) {
        this.commands = commands;
        this.maxConcurrent = maxConcurrent == 0 || maxConcurrent >= commands.length ? commands.length : maxConcurrent;
        this.namespace = namespace;
        final int max = this.maxConcurrent;
        AsyncQueryValidate.validateBegin(this.cluster, this.eventLoop, new AsyncQueryValidate.BeginListener(){

            @Override
            public void onSuccess(long key) {
                AsyncMultiExecutor.this.clusterKey = key;
                AsyncMultiExecutor.this.eventLoop.execute(AsyncMultiExecutor.this.cluster, commands[0]);
                for (int i = 1; i < max; ++i) {
                    AsyncMultiExecutor.this.executeValidateCommand(commands[i]);
                }
            }

            @Override
            public void onFailure(AerospikeException ae) {
                AsyncMultiExecutor.this.initFailure(ae);
            }
        }, commands[0].node, namespace, this.infoTimeout);
    }

    private final void executeValidateCommand(final AsyncMultiCommand command) {
        AsyncQueryValidate.validate(this.cluster, this.eventLoop, new AsyncQueryValidate.Listener(){

            @Override
            public void onSuccess() {
                AsyncMultiExecutor.this.eventLoop.execute(AsyncMultiExecutor.this.cluster, command);
            }

            @Override
            public void onFailure(AerospikeException ae) {
                AsyncMultiExecutor.this.childFailure(ae);
            }
        }, command.node, this.namespace, this.clusterKey, this.infoTimeout);
    }

    protected final void childSuccess(Node node) {
        if (this.clusterKey == 0L) {
            this.queryComplete();
        } else {
            AsyncQueryValidate.validate(this.cluster, this.eventLoop, new AsyncQueryValidate.Listener(){

                @Override
                public void onSuccess() {
                    AsyncMultiExecutor.this.queryComplete();
                }

                @Override
                public void onFailure(AerospikeException ae) {
                    AsyncMultiExecutor.this.childFailure(ae);
                }
            }, node, this.namespace, this.clusterKey, this.infoTimeout);
        }
    }

    private final void queryComplete() {
        ++this.completedCount;
        if (this.completedCount < this.commands.length) {
            int nextThread = this.completedCount + this.maxConcurrent - 1;
            if (nextThread < this.commands.length && !this.done) {
                if (this.clusterKey == 0L) {
                    this.eventLoop.execute(this.cluster, this.commands[nextThread]);
                } else {
                    this.executeValidateCommand(this.commands[nextThread]);
                }
            }
        } else if (!this.done) {
            this.done = true;
            if (this.exception == null) {
                this.onSuccess();
            } else {
                this.onFailure(this.exception);
            }
        }
    }

    final void childFailure(AerospikeException ae) {
        if (!this.done) {
            this.done = true;
            for (AsyncMultiCommand command : this.commands) {
                command.stop();
            }
            this.onFailure(ae);
        }
    }

    final void reset() {
        this.completedCount = 0;
        this.done = false;
    }

    private final void initFailure(AerospikeException ae) {
        this.onFailure(ae);
    }

    protected abstract void onSuccess();

    protected abstract void onFailure(AerospikeException var1);
}

