/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.INioCommand;
import com.aerospike.client.async.NioConnection;
import com.aerospike.client.async.NioEventLoop;
import com.aerospike.client.async.NioRecover;
import com.aerospike.client.async.TimeoutState;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.metrics.LatencyType;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;

public final class NioCommand
implements INioCommand,
Runnable,
TimerTask {
    final NioEventLoop eventLoop;
    final Cluster cluster;
    final AsyncCommand command;
    final EventState eventState;
    final HashedWheelTimer.HashedWheelTimeout timeoutTask;
    TimeoutState timeoutState;
    Node node;
    NioConnection conn;
    ByteBuffer byteBuffer;
    long begin;
    long totalDeadline;
    int state;
    int iteration;
    final boolean metricsEnabled;
    final boolean hasTotalTimeout;
    boolean usingSocketTimeout;
    boolean eventReceived;

    public NioCommand(NioEventLoop eventLoop, Cluster cluster, AsyncCommand command) {
        this.eventLoop = eventLoop;
        this.cluster = cluster;
        this.command = command;
        this.eventState = cluster.eventState[eventLoop.index];
        this.timeoutTask = new HashedWheelTimer.HashedWheelTimeout(this);
        command.bufferQueue = eventLoop.bufferQueue;
        this.metricsEnabled = cluster.metricsEnabled;
        boolean bl = this.hasTotalTimeout = command.totalTimeout > 0;
        if (eventLoop.thread == Thread.currentThread() && this.eventState.errors < 5) {
            this.run();
        } else {
            if (this.hasTotalTimeout) {
                this.totalDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(command.totalTimeout);
            }
            this.state = 1;
            eventLoop.execute(this);
        }
    }

    public NioCommand(NioCommand other, AsyncCommand command, long deadline) {
        this.eventLoop = other.eventLoop;
        this.cluster = other.cluster;
        this.command = command;
        this.eventState = other.eventState;
        this.timeoutTask = new HashedWheelTimer.HashedWheelTimeout(this);
        this.totalDeadline = other.totalDeadline;
        this.iteration = other.iteration;
        this.metricsEnabled = this.cluster.metricsEnabled;
        this.hasTotalTimeout = other.hasTotalTimeout;
        this.usingSocketTimeout = other.usingSocketTimeout;
        command.bufferQueue = this.eventLoop.bufferQueue;
        if (this.eventState.closed) {
            this.queueError(new AerospikeException("Cluster has been closed"));
            return;
        }
        if (this.eventLoop.maxCommandsInProcess > 0) {
            this.eventLoop.executeFromDelayQueue();
            if (this.eventLoop.pending >= this.eventLoop.maxCommandsInProcess) {
                if (this.eventLoop.maxCommandsInQueue > 0 && this.eventLoop.delayQueue.size() >= this.eventLoop.maxCommandsInQueue) {
                    this.queueError(new AerospikeException.AsyncQueueFull());
                    return;
                }
                this.eventLoop.delayQueue.addLast(this);
                if (deadline > 0L) {
                    this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
                }
                this.state = 2;
                return;
            }
        }
        ++this.eventState.pending;
        ++this.eventLoop.pending;
        this.executeCommand(deadline, 3);
    }

    @Override
    public void run() {
        if (this.eventState.closed) {
            this.queueError(new AerospikeException("Cluster has been closed"));
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (this.state == 1) {
                if (currentTime >= this.totalDeadline) {
                    this.queueError(new AerospikeException.Timeout(this.command.policy, true));
                    return;
                }
            } else {
                this.totalDeadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.totalTimeout);
            }
        }
        if (this.eventLoop.maxCommandsInProcess > 0) {
            this.eventLoop.executeFromDelayQueue();
            if (this.eventLoop.pending >= this.eventLoop.maxCommandsInProcess) {
                if (this.eventLoop.maxCommandsInQueue > 0 && this.eventLoop.delayQueue.size() >= this.eventLoop.maxCommandsInQueue) {
                    this.queueError(new AerospikeException.AsyncQueueFull());
                    return;
                }
                this.eventLoop.delayQueue.addLast(this);
                if (this.hasTotalTimeout) {
                    this.eventLoop.timer.addTimeout(this.timeoutTask, this.totalDeadline);
                }
                this.state = 2;
                return;
            }
        }
        long deadline = this.totalDeadline;
        if (this.hasTotalTimeout) {
            long socketDeadline;
            if (this.command.socketTimeout > 0 && (socketDeadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout)) < this.totalDeadline) {
                this.usingSocketTimeout = true;
                deadline = socketDeadline;
            }
        } else if (this.command.socketTimeout > 0) {
            this.usingSocketTimeout = true;
            deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
        }
        ++this.eventState.pending;
        ++this.eventLoop.pending;
        this.executeCommand(deadline, 0);
    }

    private final void queueError(AerospikeException ae) {
        ++this.eventState.errors;
        this.state = 12;
        this.notifyFailure(ae);
    }

    final void executeCommandFromDelayQueue() {
        long deadline = this.totalDeadline;
        if (this.command.socketTimeout > 0) {
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
            if (this.hasTotalTimeout) {
                if (socketDeadline < this.totalDeadline) {
                    this.timeoutTask.cancel();
                    this.usingSocketTimeout = true;
                    deadline = socketDeadline;
                }
            } else {
                this.usingSocketTimeout = true;
                deadline = socketDeadline;
            }
        }
        ++this.eventState.pending;
        ++this.eventLoop.pending;
        this.executeCommand(deadline, 1);
    }

    protected final void executeCommand(long deadline, int tstate) {
        this.state = 4;
        ++this.iteration;
        try {
            this.node = this.command.getNode(this.cluster);
            this.node.validateErrorCount();
            if (this.metricsEnabled) {
                this.begin = System.nanoTime();
            }
            this.byteBuffer = this.eventLoop.getByteBuffer();
            this.conn = (NioConnection)this.node.getAsyncConnection(this.eventLoop.index, this.byteBuffer);
            if (this.conn != null) {
                this.setTimeoutTask(deadline, tstate);
                this.conn.attach(this);
                this.writeCommand();
                return;
            }
            try {
                if (this.command.policy.connectTimeout > 0) {
                    this.timeoutState = new TimeoutState(deadline, tstate);
                    deadline = this.timeoutState.start + TimeUnit.MILLISECONDS.toNanos(this.command.policy.connectTimeout);
                    this.timeoutTask.cancel();
                    this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
                } else {
                    this.setTimeoutTask(deadline, tstate);
                }
                this.conn = new NioConnection(this.node.getAddress());
                this.node.connectionOpened(this.eventLoop.index);
            }
            catch (Throwable e) {
                this.node.decrAsyncConnection(this.eventLoop.index);
                throw e;
            }
            this.conn.registerConnect(this.eventLoop, this);
            this.eventState.errors = 0;
        }
        catch (AerospikeException.Connection ac) {
            ++this.eventState.errors;
            this.onNetworkError(ac, true);
        }
        catch (AerospikeException.Backoff ab) {
            ++this.eventState.errors;
            this.retry((AerospikeException)ab, true);
        }
        catch (AerospikeException ae) {
            ++this.eventState.errors;
            this.fail();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
        }
        catch (IOException ioe) {
            ++this.eventState.errors;
            this.onNetworkError(new AerospikeException.Connection(ioe), true);
        }
        catch (Throwable e) {
            ++this.eventState.errors;
            this.fail();
            this.notifyFailure(new AerospikeException(e));
            this.eventLoop.tryDelayQueue();
        }
    }

    private final void setTimeoutTask(long deadline, int tstate) {
        if (deadline <= 0L) {
            return;
        }
        switch (tstate) {
            case 0: 
            case 3: 
            case 4: {
                this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
                break;
            }
            case 1: 
            case 2: {
                if (this.timeoutTask.active()) break;
                this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
                break;
            }
        }
    }

    @Override
    public void processEvent(SelectionKey key) {
        try {
            int ops = key.readyOps();
            if ((ops & 1) != 0) {
                this.read();
            } else if ((ops & 4) != 0) {
                this.write();
            } else if ((ops & 8) != 0) {
                this.finishConnect();
            }
        }
        catch (AerospikeException.Connection ac) {
            this.onNetworkError(ac, false);
        }
        catch (AerospikeException ae) {
            if (ae.getResultCode() == 9) {
                this.onServerTimeout();
            } else if (ae.getResultCode() == 18) {
                this.onDeviceOverload(ae);
            } else {
                this.onApplicationError(ae);
            }
        }
        catch (IOException ioe) {
            this.onNetworkError(new AerospikeException.Connection(ioe), false);
        }
        catch (Throwable e) {
            this.onApplicationError(new AerospikeException(e));
        }
    }

    protected final void finishConnect() throws IOException {
        byte[] token;
        this.conn.finishConnect();
        if (this.cluster.authEnabled && (token = this.node.getSessionToken()) != null) {
            this.writeAuth(token);
            return;
        }
        this.connectComplete();
    }

    private void connectComplete() throws IOException {
        if (this.metricsEnabled) {
            this.addLatency(LatencyType.CONN);
        }
        if (this.timeoutState != null) {
            this.restoreTimeout();
        }
        this.writeCommand();
    }

    private final void restoreTimeout() {
        this.timeoutTask.cancel();
        long elapsed = System.nanoTime() - this.timeoutState.start;
        if (this.timeoutState.deadline > 0L) {
            this.timeoutState.deadline += elapsed;
        }
        if (this.totalDeadline > 0L) {
            this.totalDeadline += elapsed;
        }
        this.setTimeoutTask(this.timeoutState.deadline, this.timeoutState.state);
        this.timeoutState = null;
    }

    private final void writeAuth(byte[] token) throws IOException {
        this.state = 6;
        this.command.initBuffer();
        AdminCommand admin = new AdminCommand(this.command.dataBuffer);
        this.command.dataOffset = admin.setAuthenticate(this.cluster, token);
        this.byteBuffer.clear();
        this.byteBuffer.put(this.command.dataBuffer, 0, this.command.dataOffset);
        this.byteBuffer.flip();
        this.command.putBuffer();
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 7;
            this.eventReceived = false;
            this.conn.registerRead();
        } else {
            this.conn.registerWrite();
        }
    }

    private final void writeCommand() throws IOException {
        this.state = 9;
        this.command.writeBuffer();
        if (this.command.dataOffset > this.byteBuffer.capacity()) {
            this.byteBuffer = NioEventLoop.createByteBuffer(this.command.dataOffset);
        }
        this.byteBuffer.clear();
        this.byteBuffer.put(this.command.dataBuffer, 0, this.command.dataOffset);
        this.byteBuffer.flip();
        this.command.putBuffer();
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 10;
            ++this.command.commandSentCounter;
            this.eventReceived = false;
            this.conn.registerRead();
        } else {
            this.conn.registerWrite();
        }
    }

    protected final void write() throws IOException {
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            if (this.state == 9) {
                this.state = 10;
                ++this.command.commandSentCounter;
            } else {
                this.state = 7;
            }
            this.eventReceived = false;
            this.conn.registerRead();
        }
    }

    protected final void read() throws IOException {
        this.eventReceived = true;
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        switch (this.state) {
            case 7: {
                this.readAuthHeader();
                if (!this.conn.read(this.byteBuffer)) {
                    return;
                }
            }
            case 8: {
                this.readAuthBody();
                this.connectComplete();
                break;
            }
            case 10: {
                if (this.command.isSingle) {
                    this.readSingleHeader();
                    break;
                }
                this.readMultiHeader();
                break;
            }
            case 11: {
                if (this.command.isSingle) {
                    this.readSingleBody();
                    break;
                }
                this.readMultiBody();
            }
        }
    }

    private final void readAuthHeader() {
        this.byteBuffer.position(0);
        this.command.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        if (this.command.receiveSize < 2 || this.command.receiveSize > this.byteBuffer.capacity()) {
            throw new AerospikeException.Parse("Invalid auth receive size: " + this.command.receiveSize);
        }
        this.byteBuffer.clear();
        this.byteBuffer.limit(this.command.receiveSize);
        this.state = 8;
    }

    private final void readAuthBody() {
        int resultCode = this.byteBuffer.get(1) & 0xFF;
        if (resultCode != 0 && resultCode != 52) {
            this.node.signalLogin();
            throw new AerospikeException(resultCode);
        }
    }

    private final void readSingleHeader() throws IOException {
        this.byteBuffer.position(0);
        int receiveSize = this.command.parseProto(this.byteBuffer.getLong());
        if (receiveSize <= this.byteBuffer.capacity()) {
            this.byteBuffer.clear();
        } else {
            this.byteBuffer = NioEventLoop.createByteBuffer(receiveSize);
        }
        this.byteBuffer.limit(receiveSize);
        this.state = 11;
        if (this.conn.read(this.byteBuffer)) {
            this.readSingleBody();
        }
    }

    private final void readSingleBody() {
        this.command.sizeBuffer(this.command.receiveSize);
        this.byteBuffer.position(0);
        this.byteBuffer.get(this.command.dataBuffer, 0, this.command.receiveSize);
        this.conn.updateLastUsed();
        this.command.parseCommandResult();
        this.command.putBuffer();
        this.finish();
    }

    private final void readMultiHeader() throws IOException {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.parseGroupHeader()) {
            return;
        }
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        this.readMultiBody();
    }

    private final void readMultiBody() throws IOException {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.parseGroupBody()) {
            return;
        }
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        if (!this.parseGroupHeader()) {
            return;
        }
        if (this.command.receiveSize == 22) {
            if (!this.conn.read(this.byteBuffer)) {
                return;
            }
            this.parseGroupBody();
        }
    }

    private final boolean parseGroupHeader() {
        this.byteBuffer.position(0);
        int receiveSize = this.command.parseProto(this.byteBuffer.getLong());
        if (receiveSize <= 0) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 10;
            return false;
        }
        this.command.sizeBuffer(receiveSize);
        this.command.dataOffset = 0;
        this.byteBuffer.clear();
        if (receiveSize < this.byteBuffer.capacity()) {
            this.byteBuffer.limit(receiveSize);
        }
        this.state = 11;
        return true;
    }

    private final boolean parseGroupBody() throws IOException {
        do {
            this.byteBuffer.position(0);
            this.byteBuffer.get(this.command.dataBuffer, this.command.dataOffset, this.byteBuffer.limit());
            this.command.dataOffset += this.byteBuffer.limit();
            this.byteBuffer.clear();
            if (this.command.dataOffset >= this.command.receiveSize) {
                this.conn.updateLastUsed();
                if (this.command.parseCommandResult()) {
                    this.finish();
                    return false;
                }
                this.byteBuffer.limit(8);
                this.command.dataOffset = 0;
                this.state = 10;
                return true;
            }
            int remaining = this.command.receiveSize - this.command.dataOffset;
            if (remaining >= this.byteBuffer.capacity()) continue;
            this.byteBuffer.limit(remaining);
        } while (this.conn.read(this.byteBuffer));
        return false;
    }

    @Override
    public final void timeout() {
        if (this.state == 12) {
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (currentTime >= this.totalDeadline) {
                this.totalTimeout();
                return;
            }
            if (this.usingSocketTimeout && this.eventReceived) {
                this.eventReceived = false;
                long deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
                if (deadline >= this.totalDeadline) {
                    deadline = this.totalDeadline;
                    this.usingSocketTimeout = false;
                }
                this.eventLoop.timer.addTimeout(this.timeoutTask, deadline);
                return;
            }
        } else if (this.eventReceived) {
            this.eventReceived = false;
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
            this.eventLoop.timer.addTimeout(this.timeoutTask, socketDeadline);
            return;
        }
        if (this.iteration > this.command.maxRetries) {
            this.totalTimeout();
            return;
        }
        this.node.addTimeout();
        this.recoverConnection();
        long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
        if (this.hasTotalTimeout) {
            long remaining = this.totalDeadline - currentTime;
            if (remaining <= timeout) {
                timeout = remaining;
                this.usingSocketTimeout = false;
            }
        } else {
            currentTime = System.nanoTime();
        }
        long deadline = currentTime + timeout;
        if (!this.command.prepareRetry(true) && this.command.retryBatch(this, deadline)) {
            this.close();
            return;
        }
        this.cluster.addRetry();
        this.executeCommand(deadline, 4);
    }

    private final void totalTimeout() {
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.policy, true);
        if (this.state == 2) {
            if (this.metricsEnabled) {
                this.cluster.addDelayQueueTimeout();
            }
            this.closeFromDelayQueue();
            this.notifyFailure(ae);
            return;
        }
        this.node.addTimeout();
        this.recoverConnection();
        this.close();
        this.notifyFailure(ae);
        this.eventLoop.tryDelayQueue();
    }

    private final void recoverConnection() {
        if (this.command.policy.timeoutDelay > 0 && (this.state == 10 || this.state == 11 || this.state == 7 || this.state == 8)) {
            new NioRecover(this);
            this.conn = null;
        } else {
            this.closeConnection();
            if (this.byteBuffer != null) {
                this.eventLoop.putByteBuffer(this.byteBuffer);
            }
        }
        this.byteBuffer = null;
    }

    protected final void finish() {
        LatencyType type;
        this.complete();
        if (this.metricsEnabled && (type = this.command.getLatencyType()) != LatencyType.NONE) {
            this.addLatency(type);
        }
        try {
            this.command.onSuccess();
        }
        catch (Throwable e) {
            Log.error("onSuccess() error: " + Util.getErrorMessage(e));
        }
        this.eventLoop.tryDelayQueue();
    }

    private void addLatency(LatencyType type) {
        long elapsed = System.nanoTime() - this.begin;
        this.node.addLatency(type, elapsed);
    }

    protected final void onNetworkError(AerospikeException ae, boolean queueCommand) {
        if (this.state == 12) {
            return;
        }
        this.addError();
        this.closeConnection();
        this.retry(ae, queueCommand);
    }

    protected final void onServerTimeout() {
        if (this.state == 12) {
            return;
        }
        this.node.addTimeout();
        this.conn.unregister();
        this.node.putAsyncConnection(this.conn, this.eventLoop.index);
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.policy, false);
        this.retry((AerospikeException)ae, false);
    }

    protected final void onDeviceOverload(AerospikeException ae) {
        if (this.state == 12) {
            return;
        }
        this.addError();
        this.conn.unregister();
        this.node.putAsyncConnection(this.conn, this.eventLoop.index);
        this.node.incrErrorRate();
        this.retry(ae, false);
    }

    private final void retry(final AerospikeException ae, boolean queueCommand) {
        if (this.iteration > this.command.maxRetries) {
            this.close();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout && (currentTime = System.nanoTime()) >= this.totalDeadline) {
            this.close();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
            return;
        }
        long deadline = this.totalDeadline;
        if (this.usingSocketTimeout) {
            this.timeoutTask.cancel();
            long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
            if (this.hasTotalTimeout) {
                long remaining = this.totalDeadline - currentTime;
                if (remaining <= timeout) {
                    timeout = remaining;
                    this.usingSocketTimeout = false;
                }
            } else {
                currentTime = System.nanoTime();
            }
            deadline = currentTime + timeout;
        }
        if (queueCommand) {
            final long d = deadline;
            this.eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    if (NioCommand.this.state == 12) {
                        return;
                    }
                    NioCommand.this.retry(ae, d);
                }
            });
        } else {
            this.retry(ae, deadline);
        }
    }

    private final void retry(AerospikeException ae, long deadline) {
        this.command.onRetryException(this.node, this.iteration, ae);
        if (!this.command.prepareRetry(ae.getResultCode() != -8) && this.command.retryBatch(this, deadline)) {
            this.close();
            return;
        }
        this.cluster.addRetry();
        this.executeCommand(deadline, 2);
    }

    protected final void onApplicationError(AerospikeException ae) {
        if (this.state == 12) {
            return;
        }
        this.addError();
        if (ae.keepConnection()) {
            this.complete();
        } else {
            this.fail();
        }
        this.notifyFailure(ae);
        this.eventLoop.tryDelayQueue();
    }

    private final void notifyFailure(AerospikeException ae) {
        try {
            this.command.onFinalException(this.node, this.iteration, ae);
        }
        catch (Throwable e) {
            Log.error("onFinalException() error: " + Util.getErrorMessage(e));
        }
    }

    private void addError() {
        if (this.node != null) {
            this.node.addError();
        }
    }

    private final void complete() {
        this.conn.unregister();
        this.node.putAsyncConnection(this.conn, this.eventLoop.index);
        this.close();
    }

    private final void fail() {
        this.closeConnection();
        this.close();
    }

    private final void closeConnection() {
        if (this.conn != null) {
            this.node.closeAsyncConnection(this.conn, this.eventLoop.index);
            this.conn = null;
        }
    }

    private final void closeFromDelayQueue() {
        if (this.byteBuffer != null) {
            this.eventLoop.putByteBuffer(this.byteBuffer);
        }
        this.command.putBuffer();
        this.state = 12;
    }

    private final void close() {
        this.timeoutTask.cancel();
        if (this.byteBuffer != null) {
            this.eventLoop.putByteBuffer(this.byteBuffer);
        }
        this.command.putBuffer();
        this.state = 12;
        --this.eventState.pending;
        --this.eventLoop.pending;
    }
}

