/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cdt;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.ListOrder;
import com.aerospike.client.cdt.MapOrder;
import com.aerospike.client.util.Crypto;
import com.aerospike.client.util.Pack;
import com.aerospike.client.util.Unpacker;
import java.util.List;

public final class CTX {
    public final int id;
    public final Value value;

    public static CTX listIndex(int index2) {
        return new CTX(16, Value.get(index2));
    }

    public static CTX listIndexCreate(int index2, ListOrder order, boolean pad) {
        return new CTX(0x10 | order.getFlag(pad), Value.get(index2));
    }

    public static CTX listRank(int rank) {
        return new CTX(17, Value.get(rank));
    }

    public static CTX listValue(Value key) {
        return new CTX(19, key);
    }

    public static CTX mapIndex(int index2) {
        return new CTX(32, Value.get(index2));
    }

    public static CTX mapRank(int rank) {
        return new CTX(33, Value.get(rank));
    }

    public static CTX mapKey(Value key) {
        return new CTX(34, key);
    }

    public static CTX mapKeyCreate(Value key, MapOrder order) {
        return new CTX(0x22 | order.flag, key);
    }

    public static CTX mapValue(Value key) {
        return new CTX(35, key);
    }

    public static byte[] toBytes(CTX[] ctx) {
        return Pack.pack(ctx);
    }

    public static CTX[] fromBytes(byte[] bytes) {
        List list = (List)Unpacker.unpackObjectList(bytes, 0, bytes.length);
        int max = list.size();
        CTX[] ctx = new CTX[max / 2];
        int count = 0;
        for (int i = 0; i < max; ++i) {
            int id = (int)((Long)list.get(i)).longValue();
            if (++i >= max) {
                throw new AerospikeException.Parse("List count must be even");
            }
            Object obj = list.get(i);
            Value val = Value.get(obj);
            ctx[count++] = new CTX(id, val);
        }
        return ctx;
    }

    public static String toBase64(CTX[] ctx) {
        byte[] bytes = Pack.pack(ctx);
        return Crypto.encodeBase64(bytes);
    }

    public static CTX[] fromBase64(String base64) {
        byte[] b64 = base64.getBytes();
        byte[] bytes = Crypto.decodeBase64(b64, 0, b64.length);
        return CTX.fromBytes(bytes);
    }

    private CTX(int id, Value value) {
        this.id = id;
        this.value = value;
    }
}

