/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.command.SyncWriteCommand;
import com.aerospike.client.policy.WritePolicy;
import java.io.IOException;

public final class WriteCommand
extends SyncWriteCommand {
    private final Bin[] bins;
    private final Operation.Type operation;

    public WriteCommand(Cluster cluster, WritePolicy writePolicy, Key key, Bin[] bins, Operation.Type operation) {
        super(cluster, writePolicy, key);
        this.bins = bins;
        this.operation = operation;
    }

    @Override
    protected void writeBuffer() {
        this.setWrite(this.writePolicy, this.operation, this.key, this.bins);
    }

    @Override
    protected void parseResult(Connection conn) throws IOException {
        int resultCode = this.parseHeader(conn);
        if (resultCode == 0) {
            return;
        }
        if (resultCode == 27) {
            if (this.writePolicy.failOnFilteredOut) {
                throw new AerospikeException(resultCode);
            }
            return;
        }
        throw new AerospikeException(resultCode);
    }
}

